/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine.embed;

import dev.engine_room.flywheel.backend.engine.CpuArena;
import dev.engine_room.flywheel.backend.engine.embed.EmbeddedEnvironment;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;

public class EnvironmentStorage {
    public static final int MATRIX_SIZE_BYTES = 112;
    protected final Object lock = new Object();
    protected final ReferenceSet<EmbeddedEnvironment> environments = new ReferenceLinkedOpenHashSet();
    public final CpuArena arena = new CpuArena(112L, 32);

    public EnvironmentStorage() {
        this.arena.alloc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(EmbeddedEnvironment environment) {
        Object object = this.lock;
        synchronized (object) {
            if (this.environments.add((Object)environment)) {
                environment.matrixIndex = this.arena.alloc();
            }
        }
    }

    public void flush() {
        this.environments.removeIf(embeddedEnvironment -> {
            boolean deleted = embeddedEnvironment.isDeleted();
            if (deleted && embeddedEnvironment.matrixIndex > 0) {
                this.arena.free(embeddedEnvironment.matrixIndex);
            }
            return deleted;
        });
        for (EmbeddedEnvironment environment : this.environments) {
            environment.flush(this.arena.indexToPointer(environment.matrixIndex));
        }
    }

    public void delete() {
        this.arena.delete();
    }
}

